/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package uds

import (
	"context"
	"net"
	"time"

	"jobarranger2/src/libs/golibs/common"
)

type UdsClient struct {
	socketPath   string
	timeout 	 time.Duration
	dialer       *net.Dialer
}

func CreateUdsClient(socketPath string, timeoutInSec uint) *UdsClient {
	var d net.Dialer
	return &UdsClient{
		socketPath:   	socketPath,
		timeout: 		time.Second * time.Duration(timeoutInSec),
		dialer:       	&d,
	}
}

func (client *UdsClient) Connect() (*common.NetConnection, error) {
	ctx, cancel := context.WithTimeout(context.Background(), client.timeout)
	defer cancel()

	conn, err := client.dialer.DialContext(ctx, "unix", client.socketPath)
	if err != nil {
		return nil, err
	}

	return &common.NetConnection{
		Conn: conn,
	}, nil
}
