# Config Reader (Go Module)  
A lightweight, reflection-based configuration loader for Go, supporting file parsing, validation, and struct population with metadata tags. Can also be used as a shared library in C programs via CGo.

---

## Features  
✅ **Struct Tag-Based Validation** – Validate fields using `conf` tags (`mandatory`, `range`, `oneof`, etc.).  
✅ **Recursive Config Loading** – Supports hierarchical config files (e.g., `include` directives).  
✅ **Default Values** – Fallback values via `default=value`.  
✅ **Type-Safe** – Populates structs with type checking.  
✅ **C Compatibility** – Can be built as shared library (.so) for use in C programs.  

---

## Installation (Go)  
```bash
go get jobarranger2/src/libs/golibs/config_reader
```
>Note: Examples are provided under examples/go

---

## Installation (C)  
```bash
./build.sh  # Generates libconfig_reader.so and libconfig_reader.h
```
>Note: Examples are provided under examples/c