/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package common

import "encoding/json"

type RunFlowTable struct {
	InnerFlowID     int      `json:"inner_flow_id"`
	InnerJobnetID   uint64   `json:"inner_jobnet_id"`
	StartInnerJobID uint64   `json:"start_inner_job_id"`
	EndInnerJobID   uint64   `json:"end_inner_job_id"`
	FlowType        FlowType `json:"flow_type"`
	FlowWidth       int      `json:"flow_width"`
	FlowStyle       string   `json:"flow_style"`
}

type RunJobTable struct {
	InnerJobID        uint64                 `json:"inner_job_id"`
	InnerJobIdFsLink  uint64                 `json:"inner_job_id_fs_link"`
	InnerJobnetID     uint64                 `json:"inner_jobnet_id"`
	InnerJobnetMainID uint64                 `json:"inner_jobnet_main_id"`
	CreatedDate       int                    `json:"created_date"`
	InvoFlag          int                    `json:"invo_flag"`
	IconType          IconType               `json:"job_type"`
	Data              map[string]interface{} `json:"data"`
	TestFlag          Flag                   `json:"test_flag"`
	MethodFlag        JobRunMethod           `json:"method_flag"`
	ForceFlag         int                    `json:"force_flag"`
	TimeoutFlag       int                    `json:"timeout_flag"`
	Status            StatusType             `json:"status"`
	BootCount         int                    `json:"boot_count"`
	EndCount          int                    `json:"end_count"`
	RetryCount        int                    `json:"retry_count"`
	StartTime         int64                  `json:"start_time"`
	EndTime           int64                  `json:"end_time"`
	PointX            int                    `json:"point_x"`
	PointY            int                    `json:"point_y"`
	JobID             string                 `json:"job_id"`
	JobName           string                 `json:"job_name"`
	ContinueFlag      int                    `json:"continue_flag"`
	RunUser           string                 `json:"run_user"`
	RunUserPassword   string                 `json:"run_user_password"`
	ClientPID         int                    `json:"client_pid"`
	StopCode          int                    `json:"stop_code"`
	CommandID         string                 `json:"command_id"`
	RunCount          int                    `json:"run_count"`
}

type RunJobVariableTable struct {
	InnerJobID     uint64          `json:"inner_job_id"`
	InnerJobnetID  uint64          `json:"inner_jobnet_id"`
	BeforeVariable json.RawMessage `json:"before_variable"`
	AfterVariable  json.RawMessage `json:"after_variable"`
	SeqNo          int             `json:"seq_no"`
}

type VariableData struct {
	CurrentTime         string `json:"CURRENT_TIME"`
	IconStatus          string `json:"ICON_STATUS"`
	JobnetBootTime      string `json:"JOBNET_BOOT_TIME"`
	JobnetId            string `json:"JOBNET_ID"`
	JobnetName          string `json:"JOBNET_NAME"`
	JobnetScheduledTime string `json:"JOBNET_SCHEDULED_TIME"`
	JobExitCD           string `json:"JOB_EXIT_CD"`
	JobId               string `json:"JOB_ID"`
	FullJobId           string `json:"JOB_ID_FULL"`
	JobName             string `json:"JOB_NAME"`
	LastStatus          string `json:"LAST_STATUS"`
	InnerJobnetMainId   string `json:"MANAGEMENT_ID"`
	StdErr              string `json:"STD_ERR"`
	StdOut              string `json:"STD_OUT"`
	UserName            string `json:"USER_NAME"`
	ZBXDataType         string `json:"ZBX_DATA_TYPE"`
	ZBXLastStatus       string `json:"ZBX_LAST_STATUS"`
	ZBXLatestData       string `json:"ZBX_LATEST_DATA"`
}

type RunValueJobConTable struct {
	InnerJobID    int64  `json:"inner_job_id"`
	InnerJobnetID uint64 `json:"inner_jobnet_id"`
	ValueName     string `json:"value_name"`
}

type RunValueJobTable struct {
	InnerJobID    int64  `json:"inner_job_id"`
	InnerJobnetID uint64 `json:"inner_jobnet_id"`
	ValueName     string `json:"value_name"`
	Value         string `json:"value"`
}

type RunJobnetVariableTable struct {
	InnerJobnetID  uint64          `json:"inner_jobnet_id"`
	BeforeVariable json.RawMessage `json:"before_variable"`
	AfterVariable  json.RawMessage `json:"after_variable"`
	BeforeSeqNo    int             `json:"before_seq_no"`
	AfterSeqNo     int             `json:"after_seq_no"`
}

type SessionTable struct {
	SessionID         string `json:"session_id"`
	InnerJobnetMainID int64  `json:"inner_jobnet_main_id"`
	InnerJobID        int64  `json:"inner_job_id"`
	OperationFlag     int    `json:"operation_flag"`
	Status            int    `json:"status"`
	ForceStop         int    `json:"force_stop"`
	PID               int    `json:"pid"`
	SSHClientSocket   string `json:"ssh_client_socket"`
}

type RunJobnetTable struct {
	InnerJobnetID        uint64     `json:"inner_jobnet_id"`
	InnerJobnetMainID    uint64     `json:"inner_jobnet_main_id"`
	InnerJobID           uint64     `json:"inner_job_id"`
	UpdateDate           uint64     `json:"update_date"`
	CreatedDate          uint64     `json:"created_date"`
	RunType              int        `json:"run_type"`
	MainFlag             int        `json:"main_flag"`
	InvoFlag             int        `json:"invo_flag"`
	TimeoutFlag          int        `json:"timeout_flag"`
	Status               StatusType `json:"status"`
	ScheduledTime        uint64     `json:"scheduled_time"`
	StartTime            uint64     `json:"start_time"`
	EndTime              uint64     `json:"end_time"`
	PublicFlag           int        `json:"public_flag"`
	MultipleStartUp      int        `json:"multiple_start_up"`
	JobnetID             string     `json:"jobnet_id"`
	UserName             string     `json:"user_name"`
	JobnetName           string     `json:"jobnet_name"`
	Memo                 string     `json:"memo"`        // nullable
	ScheduleID           string     `json:"schedule_id"` // nullable
	CalendarID           string     `json:"calendar_id"` // nullable
	BootTime             string     `json:"boot_time"`   // nullable
	ExecutionUserName    string     `json:"execution_user_name"`
	RunningJobID         string     `json:"running_job_id"`   // nullable
	RunningJobName       string     `json:"running_job_name"` // nullable
	InitialScheduledTime uint64     `json:"initial_scheduled_time"`
}

type RunJobnetSummaryTable struct {
	InnerJobnetID        uint64     `json:"inner_jobnet_id"`
	UpdateDate           uint64     `json:"update_date"`
	CreatedDate          uint64     `json:"created_date"`
	InvoFlag             int        `json:"invo_flag"`
	RunType              int        `json:"run_type"`
	Status               StatusType `json:"status"`
	JobStatus            int        `json:"job_status"`
	JobnetAbortFlag      int        `json:"jobnet_abort_flag"`
	LoadStatus           int        `json:"load_status"`
	ScheduledTime        uint64     `json:"scheduled_time"`
	StartTime            uint64     `json:"start_time"`
	EndTime              uint64     `json:"end_time"`
	PublicFlag           int        `json:"public_flag"`
	MultipleStartUp      int        `json:"multiple_start_up"`
	JobnetID             string     `json:"jobnet_id"`
	UserName             string     `json:"user_name"`
	JobnetName           string     `json:"jobnet_name"`
	Memo                 string     `json:"memo"`        // nullable
	ScheduleID           string     `json:"schedule_id"` // nullable
	CalendarID           string     `json:"calendar_id"` // nullable
	Timezone             string     `json:"time_zone"`
	BootTime             string     `json:"boot_time"` // nullable
	ExecutionUserName    string     `json:"execution_user_name"`
	RunningJobID         string     `json:"running_job_id"`   // nullable
	RunningJobName       string     `json:"running_job_name"` // nullable
	StartPendingFlag     int        `json:"start_pending_flag"`
	InitialScheduledTime uint64     `json:"initial_scheduled_time"`
	JobnetTimeout        int        `json:"jobnet_timeout"`
	TimeoutRunType       int        `json:"timeout_run_type"`
	JobnetTimeoutFlag    int        `json:"jobnet_timeout_flag"`
	DeleteFlag           int        `json:"delete_flag"` // nullable
	EndingFlag           int        `json:"ending_flag"`
}

type ParameterTable struct {
	ParameterName string `json:"parameter_name"`
	Value         string `json:"value"`
	CreatedDate   uint64 `json:"created_date"`
}

type SendMessageTable struct {
	SendNo            uint64 `json:"send_no"`
	MessageDate       uint64 `json:"message_date"`
	InnerJobID        uint64 `json:"inner_job_id"`
	InnerJobnetID     uint64 `json:"inner_jobnet_id"`
	InnerJobnetMainID uint64 `json:"inner_jobnet_main_id"`
	SendStatus        int    `json:"send_status"`
	RetryCount        int    `json:"retry_count"`
	RetryDate         uint64 `json:"retry_date"`
	SendDate          uint64 `json:"send_date"`
	SendErrorDate     uint64 `json:"send_error_date"`
	MessageType       int    `json:"message_type"`
	UserName          string `json:"user_name"`
	HostName          string `json:"host_name"`
	JobnetId          string `json:"jobnet_id"`
	JobnetName        string `json:"jobnet_name"`
	JobId             string `json:"job_id"`
	JobIdFull         string `json:"job_id_full"`
	JobName           string `json:"job_name"`
	LogMessageId      string `json:"log_message_id"`
	LogMessage        string `json:"log_message"`
	ZbxIp             string `json:"zbx_ip"`
	ZbxPort           string `json:"zbx_port"`
	ZbxHost           string `json:"zbx_host"`
	ZbxItem           string `json:"zbx_item"`
}

type CalendarControlTable struct {
	CalendarID   string `db:"calendar_id" json:"calendar_id"`
	UpdateDate   string `db:"update_date" json:"update_date"`
	CreatedDate  string `db:"created_date" json:"created_date"`
	ValidFlag    Flag   `db:"valid_flag" json:"valid_flag"`
	PublicFlag   Flag   `db:"public_flag" json:"public_flag"`
	UserName     string `db:"user_name" json:"user_name"`
	CalendarName string `db:"calendar_name" json:"calendar_name"`
	Memo         string `db:"memo" json:"memo"`
	TimeZone     string `db:"time_zone" json:"time_zone"`
}

type CalendarDetailTable struct {
	CalendarID    string `db:"calendar_id" json:"calendar_id"`
	UpdateDate    string `db:"update_date" json:"update_date"`
	OperatingDate string `db:"operating_date" json:"operating_date"`
}

type RunTimeoutTable struct {
	InnerJobnetID     uint64 `json:"inner_jobnet_id"`
	InnerJobID        uint64 `json:"inner_job_id"`
	JobID             string `json:"job_id"`
	JobnetID          string `json:"jobnet_id"`
	ExecutionUserName string `json:"execution_user_name"`
	CreatedDate       uint64 `json:"created_date"`
	UpdateDate        uint64 `json:"update_date"`
	Timeout           uint64 `json:"timeout"`
	TimeoutRunType    int    `json:"timeout_run_type"`
	IsExtension       bool   `json:"is_extension"`
}
