#include "logger.h"
#include "common.h"
#include "jacommon.h"

const char	*get_program_name(const char *path)
{
	const char	*filename = NULL;

	for (filename = path; path && *path; path++)
	{
		if ('\\' == *path || '/' == *path)
			filename = path + 1;
	}

	return filename;
}


char    *jaz_strdup2(const char *filename, int line, char *old, const char *str)
{
	int	retry;
	char	*ptr = NULL;

	jaz_free(old);

	for (retry = 10; 0 < retry && NULL == ptr; ptr = strdup(str), retry--)
		;

	if (NULL != ptr)
		return ptr;

	ja_log("JASERVER100003",error_message, ERROR_MSG_SIZE, filename,line,strlen(str)+1);
	exit(FAIL);
}
