/*
** Job Arranger for ZABBIX
** Copyright (C) 2012 FitechForce, Inc. All Rights Reserved.
** Copyright (C) 2013 Daiwa Institute of Research Business Innovation Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

/*
** $Date:: 
** $Revision: 
** $Author: 
**/


//data size
#define MAX_STRING_LEN		    1024
#define MAX_ARRAY_CNT		    1024
#define FILE_PATH_LEN		    260
#define FOLDER_PATH_LEN		    260
#define PROCESS_NAME_LEN		32
#define PROCESS_ID_LEN	    	32
#define PROCESS_ARG_LEN		    32
#define PROCESS_ARG_COUNT       16
#define MAX_STACK_FRAMES        64
#define ERROR_MSG_SIZE          256

//signals definations
// #define SIGRTMIN 32
// #define SIGRTMAX 64
#define RT_SIGNAL (SIGRTMIN)
#define RT_SIGNAL1 (SIGRTMIN + 1)
#define RT_SIGNAL2 (SIGRTMIN + 2)
#define RT_SIGNAL3 (SIGRTMIN + 3)
#define RT_SIGNAL4 (SIGRTMIN + 4)
#define RT_SIGNAL5 (SIGRTMIN + 5)

//Exit status for child processes
#define EXIT_SUCCESS 0
#define EXIT_FAIL 1
#define EXIT_SIGHUP (128 + SIGHUP)
#define EXIT_SIGTERM (128 + SIGTERM)
#define TIMEOUT_SEC 5   // Timeout seconds after SIGTERM

//process type
#define MONITOR_PROCESS                    0
#define NOTIFICATION_MANAGER_PROCESS       1
#define ZABBIX_LINK_MANAGER_PROCESS        2
#define ICON_RESULT_MANAGER_PROCESS        3
#define DB_SYNC_MANAGER_PROCESS            4
#define RECOVERY_MANAGER_PROCESS           5

#define ICON_EXECUTION_MANAGER_PROCESS     6     
#define FLOW_MANAGER_PROCESS               7
#define JOBNET_MANAGER_PROCESS             8

#define TIMEOUT_MANAGER_PROCESS            9
#define TRAPPER_MANAGER_PROCESS            10
#define HOUSEKEEPER_MANAGER_PROCESS        11
#define AGENT_MANAGER_PROCESS              12

#define PROCESS_TYPE_COUNT          12

#define JA_PROCESS_TYPE_UNKNOWN		255  

#define PERMISSION  0755

extern char error_message[ERROR_MSG_SIZE];
