package main

import "jobarranger2/src/libs/golibs/common"

// EventHandler strategy interface
type EventHandler interface {
	Handle(data common.EventData, tcpCon *common.NetConnection) error
}

// Handler for JazVersion 2
type TrapperHandler struct{}

func (h *TrapperHandler) Handle(jobnetPayload common.EventData, tcpCon *common.NetConnection) error {
	// Your Jaz2 logic here (jobResultData and kind removed, implement later)
	return trapperHandler(jobnetPayload, tcpCon)
}

// Factory for versioned handlers
func EventHandlerFactory() EventHandler {
	return &TrapperHandler{}
}
