/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package main

import (
	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/config_reader/server"
	wm "jobarranger2/src/libs/golibs/worker_manager"
)

func main() {

}

type RunAction struct {
	ID            uint64 `json:"id"`
	InnerJobnetID uint64 `json:"inner_jobnet_id"`
	InnerJobID    uint64 `json:"inner_job_id"`
	ActionFlag    int    `json:"action_flag"`
	ScheduledTime uint64 `json:"scheduled_time"`
	Status        int    `json:"status"`
	JobnetID      string `json:"jobnet_id"`
}

const (
	StartPendingFlagNone = 0
	StartPendingFlagOn   = 1
	StartPendingFlagOff  = 2
)

const (
	HandleUserActionsWorkerID          = "handleUserActions"
	RecoverDelayedTransacFilesWorkerID = "recoverDelayedTransacFiles"
	CheckJobProcessWorkerID            = "checkJobProcess"
	CheckLocalProcessWorkerID          = "checkLocalProcess"
)

func ProcessEventData(data common.Data) {
}

// Main processing of recovery manager
//   - Re-execute the jobs for failover situation
//   - check process for agent icons
//   - check process for local icons
//   - Iterate ja_2_run_action_table and dispatch files according to the data
//   - Periodically checking the /in directories to detect delayed transaction file and recreate events
func StartDaemonWorkers(data common.Data) {
	reExecute(data.DB)
	wm.StartWorker(func() { checkJobProcess(data.DB) }, CheckJobProcessWorkerID, server.Options.JaCheckJobTimeout, 0, string(common.RecoveryManagerProcess))
	wm.StartWorker(func() { checkLocalProcess(data.DB) }, CheckLocalProcessWorkerID, server.Options.JaCheckJobTimeout, 0, string(common.RecoveryManagerProcess))
	wm.StartWorker(func() { handleUserActions(data.DB) }, HandleUserActionsWorkerID, 180, 0, string(common.RecoveryManagerProcess))
	wm.StartWorker(func() { recoverDelayedTransacFiles() }, RecoverDelayedTransacFilesWorkerID, 180, 0, string(common.RecoveryManagerProcess))
}
