/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package events

import (
	"fmt"
	"testing"
	"time"
)

func TestEventIconEnd(t *testing.T) {
	if *inputEvent == "" {
		t.Errorf("event flag is mandatory")
		t.FailNow()
	}
	if *inputIcon == "" {
		t.Errorf("icon flag is mandatory")
		t.FailNow()
	}

	tempEvent := *inputEvent
	fmt.Println("inputEvent:", *inputEvent)

	*inputEvent = string(TestRunEvent)
	TestEventIconRun(t) // Test ready event

	inputEvent = &tempEvent
	eventData := prepareTestEvent(t)
	err := encodeTestEvent(eventData)
	if err != nil {
		t.Error(err.Error())
		t.FailNow()
	}

	// testcase1
	fmt.Println("TestEventIconEnd testcase1 started")
	fmt.Println("waiting 2s for client_helper to exit")
	time.Sleep(2 * time.Second)
	err = EventIconEnd(eventData) 
	if err != nil {
		t.Error(err.Error())
		t.FailNow()
	} else {
		fmt.Println("TestEventIconEnd testcase1: testing with complete transaction is passed")
	}
}