/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package main

import (
	"fmt"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/database"
	"jobarranger2/src/libs/golibs/event"
	"jobarranger2/src/libs/golibs/logger/logger"
	"jobarranger2/src/libs/golibs/utils"
)

func CheckJobAgentSide(hostResult common.HostResult, jobIdList []uint64) error {

	return nil
}

func CheckJobProcess(conn database.DBConnection, eventName common.EventName, checkJobData common.CheckJobData) error {
	var err error
	var hostResults []common.HostResult
	var nextEventData common.EventData
	var nextProcessData common.IconExecutionProcessData
	funcName := "CheckJobProcess"
	processType := common.FlowProcessCheckJob

	logger.JaLog("JAFLOW400001", logger.Logging{}, funcName, "")

	nextEventData.Event.UniqueKey = common.GetUniqueKey(processName)
	nextEventData.NextProcess.Name = common.IconExecManagerProcess

	switch eventName {
	case common.EventFlowCheckAgent:
		nextEventData.Event.Name = common.EventExecCheckAgent

		hostData := common.HostData{
			Hosts: []common.HostArgs{
				{
					Hostname:  checkJobData.HostName,
					Macroname: common.JaAgentPort,
				},
			},
		}
		hostResults, err = utils.GetHostInfo(hostData)
		if err != nil {
			logger.JaLog("JAFLOW200010", logger.Logging{}, funcName,
				checkJobData.HostName, err)
			return fmt.Errorf("GetHostIP(%s) failed", checkJobData.HostName)
		}
		if len(hostResults) == 0 {
			return fmt.Errorf("GetHostIP(%s) failed, err: [%s]",
				checkJobData.HostName, "empty host results")
		} else if len(hostResults) > 0 {
			nextProcessData.CheckProcessData.HostResult = hostResults[0]
			nextProcessData.RunJobData.IconType = common.IconTypeCheckJob
		} else {
			return fmt.Errorf("unexpected host result: [%v], len: %d, expected len: 1", hostResults, len(hostResults))
		}
		nextProcessData.CheckProcessData.ServerID = server.Options.ServerID
		nextProcessData.CheckProcessData.JobIdList = checkJobData.CheckJobIdList
		nextEventData.NextProcess.Data = nextProcessData

		err = event.CreateNextEvent(nextEventData, 0, string(nextEventData.Event.Name), 0)
		if err != nil {
			logger.JaLog("JAFLOW200000", logger.Logging{}, funcName, "CreateNextEvent", err)
			return fmt.Errorf("CreateNextEvent() failed")
		}

	case common.EventFlowCheckLocal:
		nextEventData.Event.Name = common.EventExecCheckLocal
		for _, innerJobId := range checkJobData.CheckJobIdList {
			nextProcessData = common.IconExecutionProcessData{}
			nextProcessData.RunJobData.InnerJobID = innerJobId
			_, err = PrepareDataForNextProcess(conn, &nextProcessData, common.FlowProcessData{}, &processType)
			if err != nil {
				err = fmt.Errorf("data preparation for innder_job_id: %d has failed. error: [%v]",
					nextProcessData.RunJobData.InnerJobID, err)
				logger.JaLog("JAFLOW200000", logger.Logging{}, funcName, "PrepareDataForNextProcess", err)
				return fmt.Errorf("PrepareDataForNextProcess() failed")
			}
			nextEventData.NextProcess.Data = nextProcessData

			err = event.CreateNextEvent(nextEventData, nextProcessData.RunJobData.InnerJobnetID,
				nextProcessData.RunJobnetData.JobnetID, nextProcessData.RunJobData.InnerJobID)
			if err != nil {
				logger.JaLog("JAFLOW200000", logger.Logging{}, funcName, "CreateNextEvent", err)
				return fmt.Errorf("CreateNextEvent() failed")
			}
		}
	}
	logger.JaLog("JAFLOW400002", logger.Logging{}, funcName, "")
	return nil
}
