/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package main

import (
	"fmt"
	"path/filepath"
	"strconv"
	"strings"

	"jobarranger2/src/libs/golibs/logger/logger"
)

func prepareLogData(filename string) (logger.Logging, error) {
	logData := logger.Logging{}
	ext := filepath.Ext(filename)
	fileNameWithoutExt := strings.TrimSuffix(filename, ext)

	parts := strings.Split(fileNameWithoutExt, "_")
	if len(parts) < 4 {
		return logData, fmt.Errorf("unexpected filename %s", filename)
	}

	innerJobnetIDStr := parts[0]
	jobnetIDParts := parts[1 : len(parts)-3]
	jobnetID := strings.Join(jobnetIDParts, "_")

	innerJobIDStr := parts[len(parts)-3]

	innerJobnetID, err := strconv.ParseUint(innerJobnetIDStr, 10, 64)
	if err != nil {

		return logData, fmt.Errorf("unexpected filename: invalid inner_jobnet_id %s: %v", innerJobnetIDStr, err)
	}

	innerJobID, err := strconv.ParseUint(innerJobIDStr, 10, 64)
	if err != nil {

		return logData, fmt.Errorf("unexpected filename: invalid inner_job_id %s: %v", innerJobIDStr, err)
	}

	logData.JobnetID = jobnetID
	logData.InnerJobnetID = innerJobnetID
	logData.InnerJobID = innerJobID

	return logData, nil
}
