/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package main

import (
	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/database"
	"strings"
)

func escapeInsideJSONBraces(input string) string {
	var (
		builder     strings.Builder
		inJSON      bool
		braceDepth  int
		currentChar rune
	)

	for i, char := range input {
		currentChar = char

		if currentChar == '{' {
			braceDepth++
			inJSON = true
		}

		if inJSON {
			if server.Options.DBType != database.PostgresDBType {
				// Maria and Mysql
				switch currentChar {
				case '\\':
					builder.WriteString(`\\`)
				case '"':
					builder.WriteString(`\"`)
				case '\'':
					builder.WriteString(`\'`)
				case '\n':
					builder.WriteString(`\\n`)
				case '\r':
					builder.WriteString(`\\r`)
				case '\t':
					builder.WriteString(`\\t`)
				default:
					builder.WriteRune(currentChar)
				}
			} else {
				// Postgresql
				if currentChar == '\'' {
					builder.WriteString(`''`)
				} else {
					builder.WriteRune(currentChar)
				}
			}
		} else {
			builder.WriteRune(currentChar)
		}

		if currentChar == '}' {
			braceDepth--
			if braceDepth == 0 {
				inJSON = false
			}
		}

		// Safety check: bail out if malformed input
		if i == len(input)-1 && braceDepth != 0 {
			return input
		}
	}

	return builder.String()
}
