/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package monitor_utils

import (
	"fmt"
	"strings"
)

type MonitorArgs struct {
	DBHost        string
	DBPort        int
	DBName        string
	DBUser        string
	DBPassword    string
	LoadShiftTime int
	RunShiftTime  int
}

func ValidateMonitorArgs(args *MonitorArgs) error {
	var missing []string
	if args.DBHost == "" {
		missing = append(missing, "-dbhost")
	}

	if args.DBName == "" {
		missing = append(missing, "-dbname")
	}
	if args.DBUser == "" {
		missing = append(missing, "-dbuser")
	}
	if args.DBPassword == "" {
		missing = append(missing, "-dbpassword")
	}
	if args.DBPort == 0 {
		missing = append(missing, "-dbport")
	}
	if len(missing) > 0 {
		return fmt.Errorf("missing required flags: %s", strings.Join(missing, ", "))
	}
	return nil
}
