import React from "react";
import { Form, Input, Checkbox } from "antd";

const formItemLayout = {
  labelCol: {
    xs: {
      span: 25,
    },
    sm: {
      span: 6,
    },
  },
  wrapperCol: {
    xs: {
      span: 25,
    },
    sm: {
      span: 10,
    },
  },
};

function ZabbixCon({ form, onFinish }) {
  return (
    <Form
      {...formItemLayout}
      form={form}
      style={{ marginLeft: '24px', marginRight:'10px', marginTop: '10px', marginBottom: '10px' }}
      labelAlign="left"
      onFinish={onFinish}
      initialValues={{
        sslVerificationFlag: false,
      }}
    >
      <h3 className="tabHead">Zabbix connection:</h3>
      <p className="info">Please enter Zabbix api URL and redirect URL for zabbix connection.</p>
      <div id="zbxErr" className="errDiv">
        <p id="zbxerrmsg" className="errorMsg"></p>
      </div>

      <Form.Item
        className="zabbix-form-item"
        name="zabbixURL"
        label="Zabbix URL"
        rules={[
          {
            required: true,
            message: "Please input zabbix URL!",
          },
        ]}
      >
        <Input />
      </Form.Item>

        <Form.Item
        className="zabbix-form-item"
        name="zabbixRedirectURL"
        label="Zabbix Redirect URL"
        rules={[
          {
            required: true,
            message: "Please input zabbix redirect URL!",
          },
        ]}
      >
        <Input />
      </Form.Item>

      <Form.Item
        className="zabbix-form-item"
        name="sslVerificationFlag"
        valuePropName="checked"
        label="Disable SSL Verification"
      >
        <Checkbox></Checkbox>
      </Form.Item>
    </Form>
  );
}
export default ZabbixCon;
