import React from "react";
import { Form, Input, Select } from "antd";
import { REGEX_PATTERM } from "../../constants";

const formItemLayout = {
  labelCol: {
    xs: {
      span: 25,
    },
    sm: {
      span: 5,
    },
  },
  wrapperCol: {
    xs: {
      span: 25,
    },
    sm: {
      span: 12,
    },
  },
  
};

function DBconnection({ form, onFinish, initialValues }) {
  const { Option } = Select;
  return (
    <Form
      {...formItemLayout}
      labelAlign="left"
      style={{ marginLeft: '24px', marginRight:'10px', marginTop: '10px', marginBottom: '10px' }}
      form={form}
      onFinish={onFinish}
      initialValues={initialValues}
      scrollToFirstError
    >
      <h3 className="tabHead">Configure DB connection:</h3>
      <p className="info">
        Please create database manually, and set the configuration parameters
        for connection to this database. Press "Next step" button when done.
      </p>
      <div id="dbErr" className="errDiv">
        <p id="dberrmsg" className="errorMsg" style={{ fontSize: "12px" }}></p>
      </div>
      <div
      style={{
      maxHeight: '357px',
      overflow: 'auto',
      paddingRight: '10px',
      marginTop: '10px',
     }}
     >
      <Form.Item
        className="dbcon-form-item"
        name="DBType"
        label="Database Type"
        rules={[
          {
            required: true,
            message: "Please select Database Type!",
          },
        ]}
      >
        <Select
          id="dbType"
          placeholder="Select your Database Type"
          className="dbOption"
        >
          <Option value="mysql">MySQL</Option>
          <Option value="pgsql">Postgres</Option>
        </Select>
      </Form.Item>
       <div style={{ fontWeight: "bold", fontSize: "15px", marginTop: "5px" }}>
        For Job Arranger
      </div>

      <Form.Item
        className="dbcon-form-item"
        name="JazDBHost"
        label="Database Host"
        rules={[
          {
            required: true,
            message: "Please input Database Host!",
          },
        ]}
      >
        <Input />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="JazDBPort"
        label="Database Port"
        rules={[
          {
            required: true,
            message: "Please input Database Port!",
          },
          () => ({
            validator(_, value) {
              var regex = new RegExp(REGEX_PATTERM.MATCH_HANKAKU);
              if (!regex.test(value)) {
                return Promise.reject(
                  new Error("Only numeric values are allowed!")
                );
              }
              return Promise.resolve();
            },
          }),
        ]}
      >
        <Input
          addonAfter={
            <span style={{ fontSize: "12px" }}>0 - use default port</span>
          }
          maxLength={5}
        />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="JazDBName"
        label="Database Name"
        rules={[
          {
            required: true,
            message: "Please input Database Name!",
          },
        ]}
      >
        <Input />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="JazDBUser"
        label="User Name"
        rules={[
          {
            required: true,
            message: "Please input user name!",
          },
        ]}
      >
        <Input />
      </Form.Item>
      <Form.Item
        className="dbcon-form-item"
        name="JazDBPass"
        label="Password"
        rules={[
          {
            required: true,
            message: "Please input your password!",
          },
        ]}
      >
        <Input.Password />
      </Form.Item>
       <div style={{ fontWeight: "bold", fontSize: "15px", marginTop: "5px" }}>
        For Zabbix
      </div>

      <Form.Item
        className="dbcon-form-item"
        name="DBHost"
        label="Database Host"
        rules={[
          {
            required: true,
            message: "Please input Database Host!",
          },
        ]}
      >
        <Input />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="DBPort"
        label="Database Port"
        rules={[
          {
            required: true,
            message: "Please input Database Port!",
          },
          () => ({
            validator(_, value) {
              var regex = new RegExp(REGEX_PATTERM.MATCH_HANKAKU);
              if (!regex.test(value)) {
                return Promise.reject(
                  new Error("Only numeric values are allowed!")
                );
              }
              return Promise.resolve();
            },
          }),
        ]}
      >
        <Input
          addonAfter={
            <span style={{ fontSize: "12px" }}>0 - use default port</span>
          }
          maxLength={5}
        />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="DBName"
        label="Database Name"
        rules={[
          {
            required: true,
            message: "Please input Database Name!",
          },
        ]}
      >
        <Input />
      </Form.Item>

      <Form.Item
        className="dbcon-form-item"
        name="DBUser"
        label="User Name"
        rules={[
          {
            required: true,
            message: "Please input user name!",
          },
        ]}
      >
        <Input />
      </Form.Item>
      <Form.Item
        className="dbcon-form-item"
        name="DBPass"
        label="Password"
        rules={[
          {
            required: true,
            message: "Please input your password!",
          },
        ]}
      >
        <Input.Password />
      </Form.Item>
      </div>
    </Form>
  );
}
export default DBconnection;
