import React from "react";
import { Button, Result } from "antd";
import { useNavigate } from "react-router-dom";
import { t } from "i18next";
import store from "../../store";

export function Err404() {
  const navigate = useNavigate();
  const back = () => {
    navigate(`/home`);
  };
  return (
    <Result
      status="404"
      title="404"
      subTitle={t("msg-error")}
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>{t("btn-home")}</span>
        </Button>
      }
    />
  );
}

export function Err500() {
  const sessionId = store.getState().user.userInfo.sessionId;
  const navigate = useNavigate();
  const back = () => {
    if (sessionId == undefined) {
      navigate(`/login`);
    } else {
      navigate(`/home`);
    }
  };
  const responseData = store.getState().responseData.responseData;
  console.log("500 Redirect");
  console.log(responseData);

  return (
    <Result
      status="500"
      title="500"
      //subTitle={t('500-err')}
      subTitle={
        responseData.detail
          ? responseData.detail["message-detail"]
            ? t(responseData.detail["message-detail"])
            : t("500-err")
          : t("500-err")
      }
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>
            {sessionId === undefined ? t("title-login") : t("btn-home")}
          </span>
        </Button>
      }
    />
  );
}

export function ZabbixErr() {
  const sessionId = store.getState().user.userInfo.sessionId;
  const navigate = useNavigate();
  const back = () => {
    if (sessionId == undefined) {
      navigate(`/login`);
    } else {
      navigate(`/home`);
    }
  };
  const responseData = store.getState().responseData.responseData;
  console.log("500 Redirect");
  console.log(responseData);

  return (
    <Result
      status="500"
      title={t("err-zabbix-web")}
      //subTitle={t('500-err')}
      subTitle={
        <div style={{ display: 'flex', justifyContent: 'center', alignItems: 'center', gap: 3 }}>
          <h4 style={{ padding: 0, margin: 0}}>Error Details : </h4> <span> {responseData.detail
          && responseData.detail["message-detail"]}</span>
        </div>
      }
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>
            {sessionId === undefined ? t("title-login") : t("btn-home")}
          </span>
        </Button>
      }
    />
  );
}

export function DatabaseErr() {
  const sessionId = store.getState().user.userInfo.sessionId;
  const navigate = useNavigate();
  const back = () => {
    if (sessionId == undefined) {
      navigate(`/login`);
    } else {
      navigate(`/home`);
    }
  };
  const responseData = store.getState().responseData.responseData;
  console.log("500 Redirect");
  console.log(responseData);

  return (
    <Result
      status="500"
      title={t("err-dbconnection")}
      //subTitle={t('500-err')}
      subTitle={
        <div style={{ display: 'flex', justifyContent: 'center', alignItems: 'center', gap: 3 }}>
          <h4 style={{ padding: 0, margin: 0}}>Error Details : </h4> <span> {responseData.detail
          && responseData.detail["message-detail"]}</span>
        </div>
      }
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>
            {sessionId === undefined ? t("title-login") : t("btn-home")}
          </span>
        </Button>
      }
    />
  );
}

export function Err501() {
  const sessionId = store.getState().user.userInfo.sessionId;
  const navigate = useNavigate();
  const back = () => {
    if (sessionId == undefined) {
      navigate(`/login`);
    } else {
      navigate(`/home`);
    }
  };
  console.log("501 start");
  const responseData = store.getState().responseData.responseData;
  console.log("501 Redirect");
  console.log(responseData);

  return (
    <Result
      status="500"
      title="501"
      //subTitle={t('500-err')}
      subTitle={
        responseData.detail
          ? responseData.detail["message-detail"]
            ? t(responseData.detail["message-detail"])
            : t("501-err")
          : t("501-err")
      }
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>
            {sessionId === undefined ? t("title-login") : t("btn-home")}
          </span>
        </Button>
      }
    />
  );
}

export function RandomError() {
  const navigate = useNavigate();
  const back = () => {
    navigate(`/home`);
  };

  return (
    <Result
      status="warning"
      title={t("other-err")}
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>{t("btn-home")}</span>
        </Button>
      }
    />
  );
}

export function NetworkError() {
  const navigate = useNavigate();
  const back = () => {
    navigate(`/home`);
  };

  return (
    <Result
      status="error"
      title={t("network-err")}
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>{t("btn-home")}</span>
        </Button>
      }
    />
  );
}

export function ExternalLoginError() {
  const navigate = useNavigate();
  const back = () => {
    navigate(`/login`);
  };

  return (
    <Result
      status="error"
      title={t("network-err")}
      subTitle={t("ext-login-err")}
      extra={
        <Button type="primary" onClick={back}>
          <span style={{ fontSize: "12px" }}>{t("title-login")}</span>
        </Button>
      }
    />
  );
}

export default RandomError;
