import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import Backend from "i18next-http-backend";
import LanguageDetector from "i18next-browser-languagedetector";
import en from "../../locales/lang_en.json";
import jp from "../../locales/lang_jp.json";

const fallbackLng = ["en"];
const availableLanguages = ["en", "jp"];

const resources = {
  en: {
    translation: en,
  },
  jp: {
    translation: jp,
  },
};

i18n
  .use(Backend)
  .use(LanguageDetector)
  .use(initReactI18next)
  .init({
    resources,
    fallbackLng,

    detection: {
      checkWhitelist: true,
    },

    debug: false,

    whitelist: availableLanguages,

    interpolation: {
      escapeValue: false,
    },
  });

export default i18n;
