import {
  alertSuccess,
  successMessageBox,
} from "../components/dialogs/CommonDialog";
import moment from 'moment-timezone';

export const getShiftJISByteLength = (str) => {
  if (str) {
    if (str.length > 0) {
      return str.replace(
        /[^\x00-\x80｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝ ﾞ ﾟ]/g,
        "xx"
      ).length;
    }
  }
  return 0;
};

/**
 * Converts Unix timestamp to formatted local time based on a timezone.
 * @param {number} unixTime - Unix timestamp (in seconds)
 * @param {string} timeZone - Timezone name, e.g., "Asia/Rangoon"
 * @returns {string} - Formatted date string
 */
export const showLocalTime = (unixTime, timeZone) => {
  return moment.unix(unixTime).tz(timeZone).format('YYYY-MM-DD HH:mm:ss');
};

export const isNullOrEmpty = (str) => {
  return !str || str.trim().length === 0;
};

export const handleConfirmBoxState = (
  confirmBoxState,
  successTitle,
  successMessage,
  handleOk
) => {
  if (confirmBoxState) {
    alertSuccess(successTitle, successMessage, handleOk);
  } else {
    successMessageBox(successMessage);
  }
};

const Scripts = new Set();

//Dynamically Load Scripts
const loadScript = (src) => {
  return new Promise((resolve, reject) => {
    if (Scripts.has(src)) {
      resolve();
      return;
    }
    const script = document.createElement("script");
    script.src = src;
    script.onload = () => {
      Scripts.add(src);
      resolve();
    };
    script.onerror = () => reject(new Error(`Failed to load script ${src}`));
    document.body.appendChild(script);
  });
};

export const loadAllScripts = async () => {
  var basePath;
  var resourcePath;
  try {
    if (process.env.NODE_ENV === "development") {
      window.mxBasePath = `${window.location.origin}/libs/mxgraph/javascript/src`;
      basePath = `${window.location.origin}/libs/mxgraph/javascript`;
      resourcePath = `${window.location.origin}/resources`;
    } else {
      window.mxBasePath = `${window.location.origin}/jobarranger/libs/mxgraph/javascript/src`;
      basePath = `${window.location.origin}/jobarranger/libs/mxgraph/javascript`;
      resourcePath = `${window.location.origin}/jobarranger/resources`;
    }

    // Load scripts sequentially using async/await
    await loadScript(`${basePath}/examples/grapheditor/www/js/Init.js`);
    await loadScript(
      `${basePath}/examples/grapheditor/www/sanitizer/sanitizer.min.js`
    );
    await loadScript(`${resourcePath}/constants.js`);
    await loadScript(`${resourcePath}/icon_setting.js`);
    await loadScript(`${window.mxBasePath}/js/mxClient.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/EditorUi.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Sidebar.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Graph.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Editor.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Shapes.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Actions.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Menus.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Toolbar.js`);
    await loadScript(`${basePath}/examples/grapheditor/www/js/Dialogs.js`);
  } catch (error) {
    console.error("Error loading scripts:", error);
  }
};
