package main

import (
	"fmt"
	"os"

	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/logger/logger"
)

func main() {
	// Necessary values to initialize logger
	logFilePath := "/var/log/jobarranger2/jobarg_server.log"
	messageFilePath := "/etc/jobarranger2/locale/logmessage_64BIT.txt"
	logTypeStr := "file"
	maxLogFileSize := 10 * 1024 * 1024 // 10 MB
	debugLevel := 3

	// Initialize logger
	err := logger.InitLogger(logFilePath, messageFilePath, logTypeStr, maxLogFileSize, debugLevel, logger.TargetTypeServer)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to init logger: %v\n", err)
		os.Exit(1)
	}

	server.Options.UnixSockParentDir = "/usr/local/bin/jobarranger/"

	logData := logger.Logging{
		InnerJobnetMainID: 1500000000000000333,
		InnerJobnetID:     1500000000000000333,
		UpdateDate:        0, // Set appropriately if needed
		JobnetStatus:      0, // Set appropriately if known
		RunType:           0, // Set appropriately if known
		PublicFlag:        0, // Set appropriately if known
		JobnetID:          "JOBNET_36",
		JobnetName:        "JOBNET_36",
		UserName:          "Admin",
		Hostname:          "oss.linux.rhel8",

		JobID:     "JOB-1",
		JobIDFull: "JOBNET_36/JOB-1",
		JobName:   "JOB-1",
		// Other optional fields can be added as needed
	}

	// JaJobLog (insert ja_2_run_log_message_table)
	// logger.JaJobLog(common.JC_JOBNET_START, logData)

	// logData.InnerJobnetMainID = 1500000000000000334
	// logData.JobnetID = "JOBNET_37"

	// JaLog (insert ja_2_send_message_table)
	logger.JaLog("JAJOBNETLOADER400001", logData, "loader", logData.JobnetID)
	logger.JaLog("JARUNICONIF200001", logData, "func", 1)

	// Write Agent Log
	logFilePath = "/var/log/jobarranger2/jobarg_agentd.log"
	messageFilePath = "/etc/jobarranger2/locale/logmessage_64BIT_agent.txt"
	logTypeStr = "file"
	maxLogFileSize = 10 * 1024 * 1024 // 10 MB
	debugLevel = 3

	err = logger.InitLogger(logFilePath, messageFilePath, logTypeStr, maxLogFileSize, debugLevel, logger.TargetTypeAgent)
	if err != nil {
		fmt.Fprintf(os.Stderr, "failed to init logger: %v\n", err)
		os.Exit(1)
	}

	logger.WriteLog("JAAGENTHOUSEKEEPER000001", 24, 24)
	logger.WriteLog("JAAGENTHOUSEKEEPER400001", 24, 24)

}
