#include <stdio.h>
#include <unistd.h>
#include "logger.h"

int main(int argc, char const *argv[])
{
    // Necessary values to initialize logger
    char *log_file_path = "/var/log/jobarranger2/jobarg_server.log";
    char *message_file_path = "/etc/jobarranger2/locale/logmessage_64BIT.txt";
    char *logTypeStr = "file";
    char error_message[256];
    int max_log_file_size = 10 * 1024 * 1024; // 10 MB
    int log_level = 4; // Warning
    int target_type = 0; // 0 - server, 1 - agent

    // Initialize logger
    if (InitLogger(log_file_path, message_file_path, logTypeStr, max_log_file_size, log_level, target_type, error_message, sizeof(error_message)) == -1)
    {
        printf("Failed to initialize the logger: %s\n", error_message);
        return -1;
    }

    // Write logs
    if (ja_log("JARUNICONIF200001", error_message, sizeof(error_message), "func", 1) == -1)
    {
        printf("Failed to write log to the file: %s\n", error_message);
        return -1;
    }

    ja_log("JAJOBNETLOADER400001", error_message, sizeof(error_message), "loader", "My Jobnet ID");

    log_file_path = "/var/log/jobarranger2/jobarg_agentd.log";
    message_file_path = "/etc/jobarranger2/locale/logmessage_64BIT_agent.txt";
    target_type = 1; // agent
    // Initialize logger
    if (InitLogger(log_file_path, message_file_path, logTypeStr, max_log_file_size, log_level, target_type, error_message, sizeof(error_message)) == -1)
    {
        printf("Failed to initialize the logger: %s\n", error_message);
        return -1;
    }

    // Write logs
    if (write_log("JAAGENTHOUSEKEEPER000001", error_message, sizeof(error_message), 24, 5) == -1)
    {
        printf("Failed to write log to the file: %s\n", error_message);
        return -1;
    }

    write_log("JAAGENTHOUSEKEEPER400001", error_message, sizeof(error_message), "func", 24, 24);

    return 0;
}
