package main

import (
	"flag"
	"fmt"
	"os"
)

func main() {

	execFilePath := flag.String("exec-file-path", "", "Full path to the script file")
	jobRunFilePath := flag.String("job-run-file-path", "", "Full path to the job run file")
	serverIPsPath := flag.String("server-ips-path", "", "Full path to the server IPs file")

	flag.Parse()

	if *execFilePath == "" {
		fmt.Println("Error: -exec-file-path is required")
		flag.Usage()
		os.Exit(1)
	}

	if *jobRunFilePath == "" {
		fmt.Println("Error: -job-run-file-path is required")
		flag.Usage()
		os.Exit(1)
	}

	if *serverIPsPath == "" {
		fmt.Println("Error: -server-ips-path is required")
		flag.Usage()
		os.Exit(1)
	}

	fmt.Printf("Forker Helper is Running: %s %s %s\n", *execFilePath, *jobRunFilePath, *serverIPsPath)
	fmt.Fprintln(os.Stderr, "This is stderr from forker helper")

}
