/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package eventcore

import (
	"jobarranger2/src/libs/golibs/builder"
	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/uds"
)

type EventCoreResult struct {
	UDSSuccess bool
	UDSErrMsg  string
	Err        error // Only file creation error; UDS failure is not considered fatal
}

func CreateEventCore(data *common.EventData, innerJobnetId uint64, jobnetId string, innerJobId uint64) EventCoreResult {
	err := builder.CreateJsonFile(data, innerJobnetId, jobnetId, innerJobId)
	if err != nil {
		return EventCoreResult{Err: err}
	}

	socketPath := common.GetCurrentCommunicationSocketPath(data.Event.Name)
	err = uds.SendViaUDS(socketPath, data)

	var udsErrMsg string
	if err != nil {
		udsErrMsg = err.Error()
	}

	return EventCoreResult{
		UDSSuccess: err == nil,
		UDSErrMsg:  udsErrMsg,
		Err:        nil, // only file creation errors return here
	}
}
