#include <stdio.h>
#include <string.h>
#include "../../build/libconfig_reader.h" // Go library header file
#include <stdint.h>

// Include the variables you'd like to store after reading from the config
typedef struct
{
    char db_host[256];
    char db_name[256];
    char db_user[256];
    char db_schema[256];
    char db_password[256];
    int32_t db_port;
} cfg_data;

cfg_data config;

int main()
{
    // Change THIS STRUCT with values you'd like to get from the config
    cfg_line cfg[] = {
        /* PARAMETER,   VAR, DATA_TYPE, MAX_SIZE */
        {"DBHost", &config.db_host, 1, sizeof(config.db_host)},
        {"DBName", &config.db_name, 1, sizeof(config.db_name)},
        {"DBSchema", &config.db_schema, 1, sizeof(config.db_schema)},
        {"DBUser", &config.db_user, 1, sizeof(config.db_user)},
        {"DBPassword", &config.db_password, 1, sizeof(config.db_password)},
        {"DBPort", &config.db_port, 0, sizeof(config.db_port)},
    };

    // memory reset here before loading the config
    memset(&config, 0, sizeof(config));

    char *configFile = "/etc/jobarranger/jobarg_server.conf.test";

    // ** variables must be initialized in C before passing to Go **
    if (LoadConfigForC(configFile, cfg, sizeof(cfg) / sizeof(cfg[0])) != 0)
    {
        fprintf(stderr, "Config load failed (see Go logs)\n");
        return 1;
    }

    printf("DB Host: %s\n", config.db_host);
    printf("DB Name: %s\n", config.db_name);
    printf("DB Schema: %s\n", config.db_schema);
    printf("DB User: %s\n", config.db_user);
    printf("DB Password: %s\n", config.db_password);
    printf("DB Port: %d\n", config.db_port);

    memset(&config, 0, sizeof(config));

    return 0;
}
