/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
package common

type JobResult struct {
	JobId       uint64 `json:"job_id"`
	Result      int    `json:"result"`
	ReturnCode  int    `json:"return_code"`
	Signal      int    `json:"signal"`
	Hostname    string `json:"hostname"`
	Message     string `json:"message"`
	Stdout      string `json:"stdout"`
	Stderr      string `json:"stderr"`
	CurUniqueId string `json:"cur_unique_id"`
	PreUniqueId string `json:"pre_unique_id"`
}
