package builder

import "jobarranger2/src/libs/golibs/common"

type ConditionBuilder struct {
	cond common.Condition
}

func NewCondition(action common.Action) *ConditionBuilder {
	return &ConditionBuilder{
		cond: common.Condition{
			Fields: make(map[string]common.FieldCondition),
			Action: action,
		},
	}
}

func (b *ConditionBuilder) Field(name string, op common.Operator, values ...any) *ConditionBuilder {
	b.cond.Fields[name] = common.FieldCondition{
		Operator: op,
		Values:   values,
	}
	return b
}

func (b *ConditionBuilder) Build() common.Condition {
	return b.cond
}

type SQLConditionBuilder struct {
	sqlCond common.SQLCondition
}

func NewSQLCondition(sql string) *SQLConditionBuilder {
	return &SQLConditionBuilder{
		sqlCond: common.SQLCondition{
			SQL:        sql,
			Conditions: []common.Condition{},
		},
	}
}

func (b *SQLConditionBuilder) AddCondition(c common.Condition) *SQLConditionBuilder {
	b.sqlCond.Conditions = append(b.sqlCond.Conditions, c)
	return b
}

func (b *SQLConditionBuilder) DefaultAction(action common.Action) *SQLConditionBuilder {
	b.sqlCond.DefaultAction = action
	return b
}

func (b *SQLConditionBuilder) Build() common.SQLCondition {
	return b.sqlCond
}
