package main

import (
	"fmt"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/utils"
)

func jaTrapAuthHost(hostname string, tcpResponse *common.ResponseData) bool {
	TrapperLogger.JaLog("JATRAPPERMANAGER400001", "jaTrapAuthHost")

	hostData := common.HostData{
		Hosts: []common.HostArgs{
			{
				Hostname:  hostname,
				Macroname: common.JaAgentPort,
			},
		},
	}
	hostResults, err := utils.GetHostInfo(hostData)
	if err != nil {
		TrapperLogger.JaLog("JATRAPPERMANAGER400010", err.Error())
		return false
	}

	if len(hostResults) == 0 || hostResults[0].IP == "" {
		TrapperLogger.JaLog("JATRAPPERMANAGER200005", hostname)
		jaTelegramSetErr(tcpResponse, fmt.Sprintf("Host '%s' is not authenticated.", hostname), "")
		return false
	}
	return true
}
