#!/bin/bash

# Exit immediately if any command exits with a non-zero status
set -e

echo "cleaning transaction files..."
rm -rf /var/lib/jobarranger/server/*/*/*

echo "cleaning logs"
> /var/log/jobarranger/jobarg_server.log

echo "--> Running job icon unit test..."
go test -run TestEventIconEnd -event=end -icon=job
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running job icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=job
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running agentless icon unit test..."
go test -run TestEventIconEnd -event=end -icon=agentless
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running agentless icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=agentless
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running extended job icon unit test..."
go test -run TestEventIconEnd -event=end -icon=ext -cmd=jacmdsleep
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconEnd -event=end -icon=ext -cmd=jacmdtime
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconEnd -event=end -icon=ext -cmd=jacmdweek
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconEnd -event=end -icon=ext -cmd=zabbix_sender
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running extended job icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=ext -cmd=jacmdsleep
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconAbort -event=abort -icon=ext -cmd=jacmdtime
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconAbort -event=abort -icon=ext -cmd=jacmdweek
rm -rf /var/lib/jobarranger/server/*/*/*
go test -run TestEventIconAbort -event=abort -icon=ext -cmd=zabbix_sender
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running if icon unit test..."
go test -run TestEventIconEnd -event=end -icon=if
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running if icon unit abort test..."
go test -run TestEventIconAbort -event=abort -icon=if
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running start icon unit test..."
go test -run TestEventIconEnd -event=end -icon=start
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running start icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=start
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running end icon unit test..."
go test -run TestEventIconEnd -event=end -icon=end
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running end icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=end
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running calculate icon unit test..."
go test -run TestEventIconEnd -event=end -icon=calculate
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running calculate icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=calculate
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running fwait icon unit test..."
go test -run TestEventIconEnd -event=end -icon=fwait
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running fwait icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=fwait
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running fcopy icon unit test..."
go test -run TestEventIconEnd -event=end -icon=fcopy
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running fcopy icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=fcopy
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running reboot icon unit test..."
go test -run TestEventIconRun -event=run -icon=reboot
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running reboot icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=reboot
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running zabbix link icon unit test..."
go test -run TestEventIconEnd -event=end -icon=zabbix
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running zabbix link abort icon unit test..."
go test -run TestEventIconAbort -event=abort -icon=zabbix
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running task icon unit test..."
go test -run TestEventIconEnd -event=end -icon=task
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running task icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=task
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running value icon unit test..."
go test -run TestEventIconEnd -event=end -icon=value
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running value icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=value
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running info icon unit test..."
go test -run TestEventIconEnd -event=end -icon=info
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running info icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=info
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running jobnet icon unit test..."
go test -run TestEventIconEnd -event=end -icon=jobnet
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running jobnet icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=jobnet
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running if end icon unit test..."
go test -run TestEventIconEnd -event=end -icon=ifend
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running if end icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=ifend
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running m icon unit test..."
go test -run TestEventIconEnd -event=end -icon=m
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running m icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=m
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running w icon unit test..."
go test -run TestEventIconEnd -event=end -icon=w
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "--> Running w icon abort unit test..."
go test -run TestEventIconAbort -event=abort -icon=w
rm -rf /var/lib/jobarranger/server/*/*/*
echo "--> Done"

echo "!unit testing done successfully!"