/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package events

import (
	"fmt"
	"os"
	"testing"

	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/logger/logger"
)

func TestEventIconReady(t *testing.T) {
	server.Options.TmpDir = "/var/lib/jobarranger/server/"
	server.Options.UnixSockParentDir = "/usr/local/bin/jobarranger/"

	if err := logger.InitLogger(
			"/var/log/jobarranger/jobarg_server.log",
			"/root/gitlab/jobarranger2/conf/locale/logmessage_64BIT.txt",
			"file",
			1*1024*1024,
			3,
			logger.TargetTypeServer,
		); err != nil {
			fmt.Printf("failed to initialize logger: %v", err)
			os.Exit(1)
		}

	loadCommonVars()
	
	if *inputEvent == "" {
		t.Errorf("event flag is mandatory")
		t.FailNow()
	}
	if *inputIcon == "" {
		t.Errorf("icon flag is mandatory")
		t.FailNow()
	}

	eventData := prepareTestEvent(t)

	err := encodeTestEvent(eventData)
	if err != nil {
		t.Error(err.Error())
		t.FailNow()
	}

	// Testcase 1
	fmt.Println("TestEventIconReady testcase1 started")
	err = EventIconReady(eventData) 
	if err != nil {
		t.Error(err.Error())
		t.FailNow()
	} else {
		fmt.Println("testcase1: testing with complete transaction is passed")
	}

	// Testcase 2
	// fmt.Println("TestEventIconReady testcase2 started")
	// err = EventIconReady(common.EventData{}) 
	// if err == nil {
	// 	t.Error("err should not be nil")
	// 	t.FailNow()
	// } else {
	// 	fmt.Println("testcase2: testing with empty common.Data{} is passed")
	// }
}