/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package events

import (
	"path/filepath"
	"strconv"
	"strings"

	"jobarranger2/src/libs/golibs/common"
	"jobarranger2/src/libs/golibs/config_reader/server"
	"jobarranger2/src/libs/golibs/forker"
	"jobarranger2/src/libs/golibs/logger/logger"
)

func EventExecCheckAgent(eventData common.EventData) error {
	loadCommonVars()
	log := logger.Logging{}
	funcName := "EventCheckJobProcess"
	log.JaLog("JAEXECCHKPROS400001", funcName)

	eventFile := filepath.Base(eventData.Transfer.Files[0].Source)
	transactionFileId := strings.TrimSuffix(eventFile, filepath.Ext(eventFile)) // removed .json extension

	forker := forker.New(forker.ProcessData{
		ExecPath: common.ClientHelperExecPath,
		ExecParams: []string{
			"-id", transactionFileId,
			"-uds", execManagerUdsPath,
			"-in", execManagerInPath,
			"-run", execManagerRunPath,
			"-end", execManagerEndPath,
			"-error", execManagerErrorPath,
			"-clientdata", clientDataPath,
			"-ret", filepath.Join(clientDataPath, transactionFileId+".ret"),
			"-udsdir", server.Options.UnixSockParentDir,
			"-tmpdir", server.Options.TmpDir,
			"-timeout", strconv.Itoa(server.Options.Timeout),
			"-sourceIp", server.Options.SourceIP,
		},
		Detached:   true,
		StdoutPath: filepath.Join(clientDataPath, transactionFileId+".out"),
		StderrPath: filepath.Join(clientDataPath, transactionFileId+".err"),
		RetPath:    filepath.Join(clientDataPath, transactionFileId+".ret"),
	})

	_, err := forker.StartNewProcess()
	if err != nil {
		log.JaLog("JAEXECCHKPROS200001", funcName, err.Error())
		return err
	}

	log.JaLog("JAEXECCHKPROS400002", funcName)
	return nil
}
