//go:build !windows
// +build !windows

/*
** Job Arranger for ZABBIX
** Copyright (C) 2025 Daiwa Institute of Research Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

package agentutils

import (
	"io"
	"net"
	"os"

	"jobarranger2/src/libs/golibs/common"
)

type SocketConn struct {
}

func RecreateSocket(socketFilePath string) (*common.NetConnection, error) {
	f := os.NewFile(uintptr(3), "tcp-conn")
	conn, err := net.FileConn(f)
	if err != nil {
		return nil, err
	}

	netConn := common.NetConnection{
		Conn: conn,
	}

	return &netConn, nil
}

func GetTarWriter(netConn common.NetConnection) io.Writer {
	return netConn
}
