%define         _localsbindir /usr/local/sbin
%define         _localbinjobargdir /usr/local/bin/%{name}
%define         debug_package %{nil}
%define         _build_id_links none

Name:           %{name}
Version:        %{version}
Release:        1.el9
Summary:        Open-source job controller solution for your IT infrastructure
Vendor:         Daiwa Institute of Research Ltd.

Group:          Applications/Internet
License:        GPL
URL:            https://www.%{name}.info/redmine/
Source0:        %{name}-%{version}.tar.gz

BuildRequires:  docker-ce
BuildRequires:  docker-ce-cli

Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Job Arranger for ZABBIX.

%package utils
Summary:         Job Arranger Utils
Group:           Applications/Internet
Requires(pre):   /usr/sbin/useradd

%description utils
The Job Arranger utils, to be installed on systems.

%prep
%setup0 -q -n %{name}-%{version}

chmod -R a+x install-gen.sh

./install-gen.sh

%build
docker run --rm -v "$(pwd)":/workspace -w /workspace \
  --user root 10.1.8.87:5000/make_go_gcc:redhat9 \
  bash -lc "./configure --enable-utils && make"

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%pre utils
/usr/sbin/useradd -c "Job Arranger user" \
        -s /sbin/nologin -r -d %{_sysconfdir}/zabbix zabbix 2> /dev/null || :

%files utils
%defattr(-,root,root,-)
%doc AUTHORS README.md COPYING ChangeLog
%{_mandir}/man1/jobarg_exec*
%{_mandir}/man1/jobarg_get*
%{_mandir}/man1/jobarg_joblogput*
%{_mandir}/man1/jobarg_release*
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_release
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_exec
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_get
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/jobarg_joblogput

%changelog
* Sun Oct 12 2025 Copyright Daiwa Institute of Research Ltd. All Rights Reserved. <https://www.%{name}.info/jaz/jaz_release_note.html> %{version}
- Lastest RPM relese