%define _localsbindir /usr/local/sbin
%define _localbinjobargdir /usr/local/bin/jobarranger
%define debug_package %{nil}
%define _build_id_links none
%define _binary_payload w19.zstdio
%define _source_payload w19.zstdio

Name:           jobarranger
Version:        %{version}
Release:        1%{?dist}
Summary:        Open-source job controller solution for your IT infrastructure
Vendor:         Daiwa Institute of Research Ltd.

Group:          Applications/Internet
License:        GPL
URL:            https://www.%{name}.info/redmine/

Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Job Arranger for ZABBIX.

%package agentd
Summary:         Job Arranger agentd
Group:           Applications/Internet
Requires:        logrotate
Requires(pre):   /usr/sbin/useradd
Requires(post)  : systemd
Requires(preun) : systemd
Requires(postun): systemd

%description agentd
The Job Arranger agentd, to be installed on systems.

%prep
cp %{jobarg_source}/AUTHORS .
cp %{jobarg_source}/README.md .
cp %{jobarg_source}/COPYING .
cp %{jobarg_source}/ChangeLog .

%install
rm -rf $RPM_BUILD_ROOT
cd  %{jobarg_source}
make DESTDIR=$RPM_BUILD_ROOT install

# set up some required directories
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
mkdir -p $RPM_BUILD_ROOT%{_datadir}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/%{name}/agent
mkdir -p $RPM_BUILD_ROOT%{_prefix}/lib/systemd/system/
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d
mkdir -p $RPM_BUILD_ROOT%{_localbinjobargdir}/agent_socks

# init scripts
install -m 0644 -p %{jobarg_source}/misc/service/jobarg-agentd.service $RPM_BUILD_ROOT%{_prefix}/lib/systemd/system/
install -m 0644 -p %{jobarg_source}/misc/service/jobarranger_server.conf $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d/

# log rotation
cat %{jobarg_source}/misc/logrotate/jobarg-logrotate.in | sed -e 's|COMPONENT|agentd|g' > \
     $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/jobarg-agentd

%clean
rm -rf $RPM_BUILD_ROOT

%pre agentd
/usr/sbin/useradd -c "Job Arranger user" \
        -s /sbin/nologin -r -d %{_sysconfdir}/zabbix zabbix 2> /dev/null || :

%preun agentd
if [ $1 -eq 0 ]
then
  if [ -e  %{_prefix}/lib/systemd/system/jobarg-agentd.service ];then
    cd %{_prefix}/lib/systemd/system
    %{_prefix}/bin/systemctl stop jobarg-agentd.service >/dev/null 2>&1 || :
  fi

  rm -rf %{_localstatedir}/lib/%{name}/agent/*
  rm -rf %{_localbinjobargdir}/agent_socks/*
fi

%files agentd
%defattr(-,root,root,-)
%doc AUTHORS README.md COPYING ChangeLog
%{_mandir}/man8/jobarg_agentd.8.*
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/log/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/run/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/lib/%{name}
%attr(0755,zabbix,zabbix) %dir %{_localstatedir}/lib/%{name}/agent
%attr(0755,zabbix,zabbix) %dir %{_localbinjobargdir}/agent_socks
%config(noreplace) %{_sysconfdir}/logrotate.d/jobarg-agentd
%attr(0755,zabbix,zabbix) %dir %{_sysconfdir}/%{name}
%attr(0644,zabbix,zabbix) %config(noreplace) %{_sysconfdir}/%{name}/jobarg_agentd.conf
%attr(0755,zabbix,zabbix) %dir %{_sysconfdir}/%{name}/extendedjob
%attr(0755,zabbix,zabbix) %dir %{_sysconfdir}/%{name}/locale
%attr(0755,zabbix,zabbix) %{_sysconfdir}/%{name}/extendedjob/jafcheck.sh
%attr(0755,zabbix,zabbix) %{_sysconfdir}/%{name}/extendedjob/jafwait.sh
%attr(0755,zabbix,zabbix) %{_sysconfdir}/%{name}/extendedjob/jareboot.sh
%attr(0744,zabbix,zabbix) %{_sysconfdir}/%{name}/locale/agent_logmessage_64BIT.txt
%attr(0755,root,root) %{_localsbindir}/jobarg_agentd
%attr(0755,root,root) %{_localsbindir}/jobarg_framework_agent
%attr(0755,root,root) %{_localsbindir}/jobarg_manager_monitor_agent
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/fcopy_client
%attr(0755,zabbix,zabbix) %{_localbinjobargdir}/job_run_client
%attr(0744,zabbix,zabbix) %{_localbinjobargdir}/agent_manager.so
%attr(0644,root,root) /usr/lib/systemd/system/jobarg-agentd.service
%attr(0644,root,root) %{_sysconfdir}/tmpfiles.d/jobarranger_server.conf

%changelog
* Sun Oct 12 2025 Copyright Daiwa Institute of Research Ltd. All Rights Reserved. <https://www.%{name}.info/jaz/jaz_release_note.html> %{version}
- Lastest RPM relese