import React from "react";
import { useTranslation } from "react-i18next";
import generalSettingService from "../../services/generalSettingService";
import { useState, useEffect } from "react";
import { Form, Input, Select, Button, InputNumber, Switch } from "antd";
import "./GeneralSetting.scss";
import {
  alertInfo,
  confirmDialog,
} from "../../components/dialogs/CommonDialog";
import { RESPONSE_OBJ_KEY } from "../../constants";
import { useDispatch, useSelector } from "react-redux";
import { toggleConfirmBox } from "../../store/GeneralSettingSlice";
import { QuestionCircleTwoTone } from "@ant-design/icons";
import { Popover } from "antd";

const GeneralSetting = () => {
  const [rows, setRows] = useState([
    {
      zabbix_server_ip_address: "",
      zabbix_server_port_number: "",
      message_destination_hostname: "",
      message_destination_item_key: "",
      isEditing: false,
    },
  ]);

  const dispatch = useDispatch();
  const useConfirmBox = useSelector(
    (state) => state.generalSettingService.useConfirmBox
  );

  const onChange = (checked) => {
    dispatch(toggleConfirmBox(checked));
  };
  const { t } = useTranslation();
  const content = (
    <p className="message-content">
      {t("txt-confirmbox-info-yes")}
      <br />
      {t("txt-confirmbox-info-no")}
      <br />
      {t("txt-confirmbox-update")}
    </p>
  );
  const [form] = Form.useForm();
  // const [dataChanged, setDataChanged] = useState(false);
  const [initialData, setInitialData] = useState({
    jobnetViewSpan: "",
    jobnetLoadSpan: "",
    jobnetKeepSpan: "",
    joblogKeepSpan: "",
    standardTime: "",
    notification: "",
    zabbixSenderCommand: "",
    zbxHostData: "",
    retry: "",
    retryCount: "",
    retryInterval: "",
    heartbeatIntervalTime: "",
    objectLockExpiredTime: "",
    disabledEdit: true,
  });

  const [value, setValue] = useState({
    jobnetViewSpan: "",
    jobnetLoadSpan: "",
    jobnetKeepSpan: "",
    joblogKeepSpan: "",
    standardTime: "",
    notification: "",
    zabbixSenderCommand: "",
    zbxHostData: "",
    retry: "",
    retryCount: "",
    retryInterval: "",
    heartbeatIntervalTime: "",
    objectLockExpiredTime: "",
    disabledEdit: true,
  });

  const setValueData = (data) => {
    value.jobnetViewSpan = data.jobnetViewSpan;
    value.jobnetLoadSpan = data.jobnetLoadSpan;
    value.jobnetKeepSpan = data.jobnetKeepSpan;
    value.joblogKeepSpan = data.joblogKeepSpan;
    value.standardTime = data.standardTime;
    value.notification = data.notification;
    value.zabbixSenderCommand = data.zabbixSenderCommand;
    value.zbxHostData = data.zbxHostData;
    value.retry = data.retry;
    value.retryCount = data.retryCount;
    value.retryInterval = data.retryInterval;
    value.heartbeatIntervalTime = data.heartbeatIntervalTime;
    value.objectLockExpiredTime = data.objectLockExpiredTime;
    value.disabledEdit = data.disabledEdit
      ? data.disabledEdit
      : value.disabledEdit;
  };

  const setFieldData = (data) => {
    form.setFieldsValue({
      jobnetViewSpan: data.jobnetViewSpan,
      jobnetLoadSpan: data.jobnetLoadSpan,
      jobnetKeepSpan: data.jobnetKeepSpan,
      joblogKeepSpan: data.joblogKeepSpan,
      standardTime: data.standardTime,
      notification: data.notification,
      zabbixSenderCommand: data.zabbixSenderCommand,
      zbxHostData: data.zbxHostData,
      retry: data.retry,
      retryCount: data.retryCount,
      retryInterval: data.retryInterval,
      heartbeatIntervalTime: data.heartbeatIntervalTime,
      objectLockExpiredTime: data.objectLockExpiredTime,
      disabledEdit: data.disabledEdit,
    });
  };
    
  useEffect(() => {
    generalSettingService.getGeneralSetting().then((data) => {
      const zbxHostData = data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].zbxHostData;
      const parsedRows = zbxHostData.map(item => {
        const parsed = JSON.parse(item.data);
        return {
          host_id: item.host_id,
          isEditing: false,
          zabbix_server_ip_address: parsed.zabbix_server_ip_address || "",
          zabbix_server_port_number: parsed.zabbix_server_port_number || "",
          message_destination_hostname: parsed.message_destination_hostname || "",
          message_destination_item_key: parsed.message_destination_item_key || ""
        };
      });

      setRows(parsedRows);

      setInitialData({
        jobnetViewSpan:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].jobnetViewSpan,
        jobnetLoadSpan:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].jobnetLoadSpan,
        jobnetKeepSpan:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].jobnetKeepSpan,
        joblogKeepSpan:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].joblogKeepSpan,
        standardTime:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].standardTime,
        notification:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].notification,
        zabbixSenderCommand:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].zabbixSenderCommand,
        zbxHostData:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].zbxHostData,
        retry: data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].retry,
        retryCount: data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].retryCount,
        retryInterval:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].retryInterval,
        heartbeatIntervalTime:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].heartbeatIntervalTime,
        objectLockExpiredTime:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].objectLockExpiredTime,
        disabledEdit:
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].disabledEdit,
      });

      setValueData(data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA]);
      setFieldData(data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA]);
      if (
        JSON.parse(
          data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA].disabledEdit
        ) == true
      ) {
        alertInfo("", t("info-msg-read-only"));
      }
    });
  }, []);

  const reDisplayOk = () => {
    setShowGeneralValidation(false);
    const initialZbxHostData = initialData.zbxHostData;  //initialZbxHostData
    const initialRows = initialZbxHostData.map(item => {
        const zbxHostData = JSON.parse(item.data);
        return {
          host_id: zbxHostData.host_id,
          isEditing: false,
          zabbix_server_ip_address: zbxHostData.zabbix_server_ip_address || "",
          zabbix_server_port_number: zbxHostData.zabbix_server_port_number || "",
          message_destination_hostname: zbxHostData.message_destination_hostname || "",
          message_destination_item_key: zbxHostData.message_destination_item_key || ""
        };
      });
    setRows(initialRows);
    const redisplayInitialData = { 
      ...value, 
      rows: initialRows // Pass the filtered rows data
    };
    setFieldData(redisplayInitialData);
  };

  const UpdateOk = () => {
    let updateData = {
      value,
      rows
    };
    generalSettingService.UpdateGeneralSetting(updateData).then((data) => {
      if (data.type == "Incomplete") {
        alertInfo(t("warn-title-update"), t("success-text-update"));
      } else {   
        setValueData(data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA]);
        form.setFieldsValue(data.detail[RESPONSE_OBJ_KEY.AJAX_MESSAGE_DATA]);

        alertInfo(t("success-title-update"), t("success-text-update"));
      }
    });
  };
 
  function cancel() {
    return false;
  }

  const [showGeneralValidation, setShowGeneralValidation] = useState(false);
  const [validationMsg, setValidationMsg] = useState("");

  const onFinish = (values) => {
    setShowGeneralValidation(false);
    let hasInvalid = false;
    const combinations = new Map();
    let hasDuplicate = false;
    
    let duplicateIndexes = [];
    rows.forEach((row, index) => {
      const id = row.host_id;
      const ip = row.zabbix_server_ip_address;
      const port = row.zabbix_server_port_number;
      const itemKey = row.message_destination_item_key;
      const combo = `${ip}-${port}-${itemKey}`;
      if (combinations.has(combo)) {
        hasDuplicate = true;
        duplicateIndexes.push(index);
      } else {
        combinations.set(combo, index);
      }
      if (validateRowFields(row, index)) {
        hasInvalid = true;
      }
    });

    if (hasDuplicate) {
      setValidationMsg(t("validate-message-duplicate-found"));
      setShowGeneralValidation(true);
      return;
    }

    if (hasInvalid) return;

    const updatedData = { ...values, rows };
    if (dataChanged(updatedData)) {
      setValueData(values);
      confirmDialog(
        t("warn-title-update"),
        t("warn-mess-update"),
        UpdateOk,
        cancel
      );
    }
  };

  const reDisplay = () => {
    if (dataChanged(form.getFieldsValue())) {
      confirmDialog(
        t("warn-mess-title"),
        t("warn-mess-redisplay"),
        reDisplayOk,
        cancel
      );
    }
  };

  const [originalRows, setOriginalRows] = useState([]);
  const [isInvalid, setIsInvalid] = useState(true);
  const [invalidRows, setInvalidRows] = useState({});
  const [showValidation, setShowValidation] = useState(false);

  const markInvalidField = (index, field, isInvalid) => {
    setInvalidRows((prev) => ({ 
      ...prev,
      [index]: {
        ...prev[index],
        [field]: isInvalid 
      }
    }));
  };


  const requiredFields = [
    "zabbix_server_ip_address",
    "zabbix_server_port_number",
    "message_destination_item_key"
  ];

  const ipPattern = /^([0-9]{1,3}\.){3}[0-9]{1,3}$/;
  const validateRowFields = (row, index) => {
    setShowValidation(true);
    let hasInvalid = false;
    let errorMessage = "";
    requiredFields.forEach((field) => {
      const isEmpty = !row[field]?.trim();
      markInvalidField(index, field, isEmpty);
      if (isEmpty) hasInvalid = true;
      if (field === "zabbix_server_ip_address" && !ipPattern.test(row[field])) {
        markInvalidField(index, field, row[field]);
        errorMessage = "Invalid IP address.";
        hasInvalid = true;
      }
    });
    return hasInvalid;
  };

  const dataChanged = (values) => {
    for (let key in value) {
      if (value[key] !== values[key]) return true;
    }
    return JSON.stringify(rows) !== JSON.stringify(initialData.zbxHostData);
  };

  const handleAddRecordButtonClick = () => {
    setIsInvalid(true);
    setShowValidation(false);
    const newIndex = rows.length;
    setRows([
      ...rows,
      {
        zabbix_server_ip_address: "",
        zabbix_server_port_number: "",
        message_destination_hostname: "",
        message_destination_item_key: "",
        isEditing: true,
      },
    ]);
    setInvalidRows(prev => ({ ...prev, [newIndex]: false }));
  };

  const handleInputChange = (index, field, value) => {
    const updatedRows = [...rows];
    updatedRows[index][field] = value;
    setRows(updatedRows);
  };

  const handleSave = (index) => {
    const row = rows[index];

    const hasInvalid = validateRowFields(row, index);
    if (hasInvalid) {
      setIsInvalid(true);
      return;
    }

    const updatedRows = [...rows];
    updatedRows[index].isEditing = false;
    setRows(updatedRows);
  };

  const handleEdit = (index) => {
    const updatedOriginalRows = [...originalRows];
    updatedOriginalRows[index] = { ...rows[index] };
    setOriginalRows(updatedOriginalRows);

    const updatedRows = [...rows];
    updatedRows[index].isEditing = true;
    setRows(updatedRows);
  };

  const handleCancel = (index) => {
    const updatedRows = [...rows];
    if (originalRows[index] == undefined) {
      updatedRows.splice(index, 1);
    } else if (originalRows[index]) {
      updatedRows[index] = { ...originalRows[index], isEditing: false };
    } else {
      updatedRows[index].isEditing = false;
    }
    setRows(updatedRows);
  }

  const handleDelete = (index) => {
    const updatedRows = [...rows];
    updatedRows.splice(index, 1);
    setRows(updatedRows);
  };

  return (
    <div>
      <Form
        id="create-form"
        labelCol={{ xs: 10, sm: 10, md: 8, lg: 8, xl: 5 }}
        form={form}
        name="control-hooks"
        onFinish={onFinish}
        disabled={JSON.parse(value.disabledEdit)}
      >
        <fieldset>
          <legend>{t("lab-lasys-sett")} :</legend>
          <Form.Item
            name="standardTime"
            label={t("lab-job-arr-std-time")}
            className="general-form-item"
          >
            <Select style={{ width: "300px" }}>
              <Select.Option value="0">{t("sel-loc-time")}</Select.Option>
              <Select.Option value="1">{t("sel-ser-time")}</Select.Option>
            </Select>
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="jobnetViewSpan"
            label={t("lab-jn-vi-sp")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} max={1059127200} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="jobnetLoadSpan"
            label={t("lab-jn-lo-sp")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} max={2147483647} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="jobnetKeepSpan"
            label={t("lab-jn-ke-sp")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} max={2147483647} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="joblogKeepSpan"
            label={t("lab-jl-ke-sp")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} max={2147483647} style={{ width: "300px" }} />
          </Form.Item>
        </fieldset>
        <fieldset>
          <legend>{t("lab-zab-noti-sett")} :</legend>
          <Form.Item
            name="notification"
            label={t("lab-zab-noti")}
            className="general-form-item"
          >
            <Select style={{ width: "300px" }}>
              <Select.Option value="0">{t("sel-no")}</Select.Option>
              <Select.Option value="1">{t("sel-yes")}</Select.Option>
            </Select>
          </Form.Item>
          <Form.Item
            name="retry"
            label={t("lab-retry")}
            className="general-form-item"
          >
            <Select style={{ width: "300px" }}>
              <Select.Option value="0">{t("sel-no-retry")}</Select.Option>
              <Select.Option value="1">{t("sel-retry")}</Select.Option>
            </Select>
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="retryCount"
            label={t("lab-retry-count")}
            rules={[{ required: true }]}
          >
            <InputNumber min={0} max={2147483647} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="retryInterval"
            label={t("lab-retry-inter")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} max={2147483647} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="zabbixSenderCommand"
            label={t("lab-zab-sen-com")}
            rules={[{ required: true }]}
          >
            <Input style={{ width: "300px" }} />
          </Form.Item>
        </fieldset>

        <fieldset>
          {showGeneralValidation && (
            <div style={{ color: "red", marginBottom: "10px" }}>{validationMsg}</div>
          )}
          <table border="1" cellpadding="1" className="generalTable" style={{width: "50%"}} >
            <thead><tr>
              <th className="input-field-coloum"><span>*</span>{t("lab-zab-ser-ip-add")}</th>
              <th className="input-field-coloum"><span>*</span>{t("lab-zab-ser-po-num")}</th>
              <th className="input-field-coloum"><span></span>{t("lab-mes-des-ser")}</th>
              <th className="input-field-coloum"><span>*</span>{t("lab-mes-des-item-key")}</th>
              <th className="button-coloum"></th>
            </tr></thead>
            <tbody>
              {rows.map((row, index) => (
                <tr key={index}>
                  <td className="input-field-coloum">
                    {row.isEditing ? (
                      <>
                      <input type="text" value={row.zabbix_server_ip_address}
                        onChange={(e) => {
                          handleInputChange(index, "zabbix_server_ip_address", e.target.value);
                          markInvalidField(index, row.zabbix_server_ip_address, false);
                        }}
                        style={{ border: (invalidRows[index]?.zabbix_server_ip_address || row.zabbix_server_ip_address.trim() === "")
                           ? "1px solid red" : "1px solid grey" }}/>
                        {invalidRows[index]?.zabbix_server_ip_address && (
                          <span style={{ color: "red", fontSize: "12px" }}>
                            {t("err-msg-general-setting-invalid-ip")}
                          </span>
                        )}
                      </>
                    ) : ( row.zabbix_server_ip_address )}
                  </td>
                  <td className="input-field-coloum">
                    {row.isEditing ? (
                      <input type="number" min={0} max={65535} value={row.zabbix_server_port_number}
                        onChange={(e) => {
                          let value = e.target.value;

                          // Allow only digits
                          if (value === "" || /^\d+$/.test(value)) {
                            handleInputChange(index, "zabbix_server_port_number", value);

                            // Check validity
                            const num = Number(value);
                            const isInvalid = value === "" || num < 0 || num > 65535;
                            markInvalidField(index, "zabbix_server_port_number", isInvalid);
                          }
                        }}
                        onBlur={() => {
                          // Clamp value on blur
                          let num = Number(row.zabbix_server_port_number);
                          if (isNaN(num)) num = 0;
                          if (num > 65535) num = 65535;
                          if (num < 0) num = 0;
                          handleInputChange(index, "zabbix_server_port_number", String(num));
                        }}
                        style={{ border: (invalidRows[index]?.zabbix_server_port_number || row.zabbix_server_port_number.trim() === "")
                           ? "1px solid red" : "1px solid grey" }}/>
                    ) : ( row.zabbix_server_port_number )}
                  </td>
                  <td className="input-field-coloum">
                    {row.isEditing ? (
                      <input type="text" value={row.message_destination_hostname}
                        onChange={(e) => {
                          handleInputChange(index, "message_destination_hostname", e.target.value);
                          markInvalidField(index, row.message_destination_hostname, false);
                        }}
                      />
                    ) : ( row.message_destination_hostname )}
                  </td>
                  <td className="input-field-coloum">
                    {row.isEditing ? (
                      <input type="text" value={row.message_destination_item_key}
                        onChange={(e) => {
                          handleInputChange(index, "message_destination_item_key", e.target.value);
                          markInvalidField(index, row.message_destination_item_key, false);
                        }}
                        style={{ border: (invalidRows[index]?.message_destination_item_key || row.message_destination_item_key.trim() === "")
                           ? "1px solid red" : "1px solid grey" }}/>
                    ) : ( row.message_destination_item_key )}
                  </td>
                  <td className="button-coloum">
                    {row.isEditing ? (
                      <div>
                        <button className="save-button" type="button" onClick={() => handleSave(index)}>{t("btn-save")}</button>
                        <button className="cancel-button" type="button" onClick={() => handleCancel(index)}>{t("btn-cancel")}</button>
                      </div>
                    ) : (
                      <div>
                        <button className="edit-button" type="button" onClick={() => handleEdit(index)}>{t("btn-edit")}</button>
                        <button className="delete-button" type="button" onClick={() => handleDelete(index)}>{t("btn-delete")}</button>
                      </div>
                    )}
                  </td>
                </tr>
              ))}
              <tr className="no-border">
                <td></td><td></td><td></td><td></td>
                <td>
                  <button className="add-button" type="button" onClick={handleAddRecordButtonClick}>{t("btn-add")}</button>
                </td>
              </tr>
            </tbody>
          </table>
        </fieldset>

        <fieldset>
          <legend>{t("lab-web-sett")} :</legend>
          <Form.Item
            className="general-form-item"
            name="heartbeatIntervalTime"
            label={t("lab-heartbeat-interval")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            className="general-form-item"
            name="objectLockExpiredTime"
            label={t("lab-objlock-expired-time")}
            rules={[{ required: true }]}
          >
            <InputNumber min={1} style={{ width: "300px" }} />
          </Form.Item>
          <Form.Item
            name="messagebox"
            label={t("lab-conf-box")}
            className="general-form-item"
          >
            <div style={{ display: "flex" }}>
              <Switch
                onChange={onChange}
                class="messageBox"
                unCheckedChildren={t("btn-no")}
                checkedChildren={t("btn-yes")}
                checked={useConfirmBox}
              />
              <Popover content={content} trigger="click">
                <QuestionCircleTwoTone
                  style={{
                    marginLeft: "10px",
                    fontSize: "15px",
                  }}
                />
              </Popover>
            </div>
          </Form.Item>

        </fieldset>
        <div style={{ height: "60px" }}></div>
        <br className="small" />
        <span style={{ fontWeight: "bold" }} className="general-info">
          {t("lab-remark1")}{" "}
        </span>
        <br className="small" />
        <span style={{ fontWeight: "bold" }} className="general-info">
          {t("lab-remark2")}{" "}
        </span>
        <br className="small" />
        <span style={{ fontWeight: "bold" }} className="general-info">
          {t("lab-remark3")}{" "}
        </span>
        <br className="small" />
        <div style={{ float: "right" }}>
          <Form.Item className="general-form-item">
            <Button onClick={reDisplay}>{t("btn-redispaly")}</Button>
            <Button
              type="primary"
              htmlType="submit"
              style={{ marginLeft: "10px" }}
            >
              {t("btn-update")}
            </Button>
          </Form.Item>
        </div>
      </Form>
    </div>
  );
};
export default GeneralSetting;
