import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { SERVICE_RESPONSE } from "../constants";
import jobExecutionManagementService from "../services/JobExecutionManagementService";
import moment from "moment";

const initialState = {
  loading: false,
  data: [],
  selectedRow: [],
  selectedObject: [],
  hideRow: [],
  updateScheduleDialogVisible: false,
  intervelId: null
};

  function getCurrentDateTime() {
  const now = new Date();
  const pad = (num) => num.toString().padStart(2, '0');
 
  const year = now.getFullYear();
  const month = pad(now.getMonth() + 1);
  const day = pad(now.getDate());
  const hours = pad(now.getHours());
  const minutes = pad(now.getMinutes());
  const seconds = pad(now.getSeconds());
 
  return `${year}${month}${day}${hours}${minutes}${seconds}`;
}

export const getAllOperationList = createAsyncThunk(
  "allOperationList/getAllOperationList",
  async (intervalId, {reject}) => {
    const response = await jobExecutionManagementService.getAllOperationList();
    if(response.type === SERVICE_RESPONSE.OK){
      return response.detail.data;
    }else{
      return reject();
    }
  }
);

export const fetchAllOperationList = () => {
  return async (dispatch, getState) => {
    try {
      const currentTz = moment.tz.guess();
      const payload = {
        date: getCurrentDateTime(),
        timezone: currentTz,
      };

      const result =
      await jobExecutionManagementService.getAllOperationList(payload).then(
        (result) => {
          let prepareData = result.detail.data.filter(
            (item) =>
              !getState()
                .allOperationList.hideRow.includes(item?.inner_jobnet_id)
          );
          dispatch(setAllListData(prepareData));
          return prepareData;
        }
      );
    return result;
    } catch (e) {
      console.error(e);
    }
  };
};

export const allOperationListSlice = createSlice({
  name: "allOperationList",
  initialState,
  reducers: {
    SET_INFO: (state) => {
      state.loading = true;
    },
    setSelectedRowKeys: {
      reducer: (state, action) => {
        if (action.payload) {
          state.selectedRow = action.payload;
        }
      },
      prepare: (newSelect) => {
        return { payload: newSelect };
      },
    },
    setSelectedObject: {
      reducer: (state, action) => {
        if (action.payload) {
          state.selectedObject = action.payload;
        }
      },
      prepare: (newSelect) => {
        return { payload: newSelect };
      },
    },
    hideDataOnTable : (state, action) => {
      state.hideRow = state.hideRow.concat(state.selectedRow)
      let prepareData = state.data.filter(item => !state.selectedRow.includes(item.inner_jobnet_id));
      state.data = prepareData;
      state.selectedObject = [];
      state.selectedRow = [];
    },
    updateVisibleScheduleDialog : (state, action) => {
      state.updateScheduleDialogVisible = action.payload;
    },
    setIntervalId : (state, action) => {
      state.intervelId = action.payload
    },
    setAllListData : (state, action) => {
      state.data = action.payload
    } 
  },
  extraReducers(builder) {
    builder
      .addCase(getAllOperationList.pending, (state) => {
        state.loading = true;
      })
      .addCase(getAllOperationList.fulfilled, (state, action) => {
        let prepareData = action.payload.filter(item => !state.hideRow.includes(item.inner_jobnet_id));
        state.data = prepareData;
        state.loading = false;
      })
      .addCase(getAllOperationList.rejected, (state) => {
        state.loading = false;
        clearInterval(state.intervelId)
        state.intervelId = null;
      });
  },
});

export default allOperationListSlice.reducer;

export const {
  setSelectedRowKeys,
  setSelectedObject,
  hideDataOnTable,
  updateVisibleScheduleDialog,
  setIntervalId,
  setAllListData
} = allOperationListSlice.actions;
