import { useSelector } from "react-redux";
import "../displayModalList/DisplayModalList.scss";
import JobExecutionDialog from "../jobExecutionDialog/JobExecutionDialog";
import { useState } from "react";

const DisplayExecuteModalList = () => {
  const [activeModalId, setActiveModalId] = useState(null);
  const executeJobData = useSelector(
    (state) => state.jobExecution.executeJobData
  );
  

  return (
    <>
      {executeJobData.map((dialog) => {

        return (
            <JobExecutionDialog key={dialog.id} id={dialog.id} cell={dialog} activeModalId={activeModalId} setActiveModalId={setActiveModalId} />
        );
      })}
    </>
  );
};

export default DisplayExecuteModalList;
