import React from "react";
import { Button, Affix, Tooltip, Menu } from "antd";
import i18next, { t } from "i18next";
import { useDispatch, useSelector } from "react-redux";
import store from "../../store";
import {
  getErrorOperationList,
  hideDataOnTable,
  setSelectedObject,
  setSelectedRowKeys,
} from "../../store/ErrorOperationListSlice";
import { alertError } from "../dialogs/CommonDialog";
import JobExecutionService from "../../services/jobExecutionService";
import {
  LOAD_STATUS_TYPE,
  RUN_JOB_STATUS_TYPE,
  SERVICE_RESPONSE,
} from "../../constants";

const JobExecutionErrorTableContextMenu = ({ value, tableType, record }) => {
  const t = i18next.t;
  const dispatch = useDispatch();
  const selectedObject = useSelector(
    (state) => state.errorOperationList.selectedObject
  );
  var hideMenuItemErrDisabled = false;
  var stopMenuItemErrDisabled = true;
  var delayMenuItemErrDisabled = true;

  const delayscheduleEnabled = () => {
    stopMenuItemErrDisabled = false;
    delayMenuItemErrDisabled = false;
  };

  if (selectedObject.length === 1) {
    const loadStatus = parseInt(selectedObject[0].loadStatus);
    const jobStatus = parseInt(selectedObject[0].intStatus);

    if (loadStatus === LOAD_STATUS_TYPE.DELAY) {
      delayscheduleEnabled();
    } else if (jobStatus === RUN_JOB_STATUS_TYPE.DURING) {
      stopMenuItemErrDisabled = false;
    }
  } else if (selectedObject.length > 1) {
    if (
      selectedObject.every(
        (item) => parseInt(item.intStatus) === RUN_JOB_STATUS_TYPE.DURING
      )
    ) {
      stopMenuItemErrDisabled = false;
      if (
        selectedObject.every(
          (item) => parseInt(item.loadStatus) === LOAD_STATUS_TYPE.DELAY
        )
      ) {
        delayMenuItemErrDisabled = false;
      }
    }
  }

  const jobExecManagementItems = [
    {
      id: "btnErrHide",
      label: t("btn-hide"),
      key: "item-1",
      onClick: () => {
        if (store.getState().errorOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          store.dispatch(hideDataOnTable());
        }
      },
      disabled: hideMenuItemErrDisabled,
    },
    {
      id: "btnErrStop",
      label: t("btn-stop"),
      key: "item-2",
      onClick: () => {
        if (store.getState().errorOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          JobExecutionService.stopErrorJobnetSummary({
            innerJobnetIdList: store.getState().errorOperationList.selectedRow,
          }).then((res) => {
            store.dispatch(setSelectedRowKeys([]));
            store.dispatch(setSelectedObject([]));
            if (res.type === SERVICE_RESPONSE.OK) {
              // dispatch(getErrorOperationList());
            } else {
              alertError("", res.error.message);
            }
          });
        }
      },
      disabled: stopMenuItemErrDisabled,
    },
    {
      id: "btnErrDelay",
      label: t("btn-delay"),
      key: "item-3",
      onClick: () => {
        if (store.getState().errorOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          JobExecutionService.delayJobnetSummary({
            innerJobnetIdList: store.getState().errorOperationList.selectedRow,
            loadStatusList: store
              .getState()
              .errorOperationList.selectedObject.map((item) => item.loadStatus),
          }).then((res) => {
            store.dispatch(setSelectedRowKeys([]));
            store.dispatch(setSelectedObject([]));
            if (res.type === SERVICE_RESPONSE.OK) {
              // dispatch(getErrorOperationList());
            } else {
              alertError("", res.error.message);
            }
          });
        }
      },
      disabled: delayMenuItemErrDisabled,
    },
  ];

  return <Menu items={jobExecManagementItems} />;
};
export default JobExecutionErrorTableContextMenu;
