import React from "react";
import { Button, Affix, Tooltip, Menu } from "antd";
import i18next, { t } from "i18next";
import { useDispatch, useSelector } from "react-redux";
import store from "../../store";
import {
  getDuringOperationList,
  hideDataOnTable,
  setSelectedObject,
  setSelectedRowKeys,
} from "../../store/DuringOperationListSlice";
import { alertError } from "../dialogs/CommonDialog";
import JobExecutionService from "../../services/jobExecutionService";
import {
  LOAD_STATUS_TYPE,
  RUN_JOB_STATUS_TYPE,
  SERVICE_RESPONSE,
} from "../../constants";

const JobExecutionDuringTableContextMenu = ({ value, tableType, record }) => {
  const t = i18next.t;
  const dispatch = useDispatch();
  const selectedItem = useSelector(
    (state) => state.duringOperationList.selectedObject
  );
  var hideMenuItemRunningDisabled = true;
  var stopMenuItemRunningDisabled = true;
  var delayMenuItemRunningDisabled = true;

  const isDuringStatus = (item) =>
    parseInt(item.intStatus) === RUN_JOB_STATUS_TYPE.DURING;
  const isDelayStatus = (item) =>
    parseInt(item.loadStatus) === LOAD_STATUS_TYPE.DELAY;

  const someItemsWithStatus = (items, statusCheck) => items.some(statusCheck);
  const everyItemWithStatus = (items, statusCheck) => items.every(statusCheck);

  if (selectedItem.length === 1) {
    const jobStatus = parseInt(selectedItem[0].intStatus);
    const loadStatus = parseInt(selectedItem[0].loadStatus);

    if (jobStatus === RUN_JOB_STATUS_TYPE.DURING) {
      stopMenuItemRunningDisabled = false;
      if (loadStatus === LOAD_STATUS_TYPE.DELAY) {
        delayMenuItemRunningDisabled = false;
      }
    }
  } else if (selectedItem.length > 1) {
    if (
      someItemsWithStatus(selectedItem, isDuringStatus) ||
      someItemsWithStatus(selectedItem, isDelayStatus) ||
      everyItemWithStatus(selectedItem, isDuringStatus)
    ) {
      stopMenuItemRunningDisabled = false;
      if (everyItemWithStatus(selectedItem, isDelayStatus)) {
        delayMenuItemRunningDisabled = false;
      }
    }
  }

  const jobExecManagementItems = [
    {
      id: "btnDurHide",
      label: t("btn-hide"),
      key: "item-1",
      onClick: () => {
        if (store.getState().duringOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          store.dispatch(hideDataOnTable());
        }
      },
      disabled: hideMenuItemRunningDisabled,
    },
    {
      id: "btnDurStop",
      label: t("btn-stop"),
      key: "item-2",
      onClick: () => {
        if (store.getState().duringOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          JobExecutionService.stopAllJobnetSummary({
            innerJobnetIdList: store.getState().duringOperationList.selectedRow,
            statusList: store
              .getState()
              .duringOperationList.selectedObject.map((item) => item.intStatus),
          }).then((res) => {
            store.dispatch(setSelectedRowKeys([]));
            store.dispatch(setSelectedObject([]));
            if (res.type === SERVICE_RESPONSE.OK) {
              // dispatch(getDuringOperationList());
            } else {
              alertError("", res.error.message);
            }
          });
        }
      },
      disabled: stopMenuItemRunningDisabled,
    },
    {
      id: "btnDurDelay",
      label: t("btn-delay"),
      key: "item-3",
      onClick: () => {
        if (store.getState().duringOperationList.selectedRow.length === 0) {
          alertError("", t("err-msg-no-select-data"));
        } else {
          JobExecutionService.delayJobnetSummary({
            innerJobnetIdList: store.getState().duringOperationList.selectedRow,
            loadStatusList: store
              .getState()
              .duringOperationList.selectedObject.map(
                (item) => item.loadStatus
              ),
          }).then((res) => {
            store.dispatch(setSelectedRowKeys([]));
            store.dispatch(setSelectedObject([]));
            if (res.type === SERVICE_RESPONSE.OK) {
              // dispatch(getDuringOperationList());
            } else {
              alertError("", res.error.message);
            }
          });
        }
      },
      disabled: delayMenuItemRunningDisabled,
    },
  ];

  return <Menu items={jobExecManagementItems} />;
};
export default JobExecutionDuringTableContextMenu;
