import React, { useState, useEffect } from "react";
import "./App.scss";
import "antd/dist/antd.css";
import { useNavigate } from "react-router-dom";
import { setupInterceptor } from "./common/http";
import { useDispatch } from "react-redux/es/exports";
import { LOCAL_STORAGE } from "./constants/index";
import { removeUserInfo } from "./store/UserSlice";
import AuthService from "./services/Auth";
import store from "./store";
import { MainRoutes } from "./router/Routes";

function App() {
  const navigate = useNavigate();
  const dispatch = useDispatch();
  const [mounted, setMounted] = useState(false);

  const relogin = () => {
    dispatch(removeUserInfo());
    navigate("/login");
  };

  const errRedirect = (errCode) => {
    const routes = {
      404: "/404",
      500: "/500",
      501: "/501",
      zabbixErr: '/zabbixErr',
      databaseErr: '/databaseErr',
      error: "/error",
      config: "/setup",
      networkErr: "/networkErr",
    };
    navigate(routes[errCode] || "/");
  };

  useEffect(() => {
    const preloader = document.getElementById('preloader');
    if (preloader) {
      preloader.style.display = 'none';
    }
  }, []);

  useEffect(() => {
    const initialize = async () => {
      try {
        const result = await AuthService.getExternalLoginLink();
          localStorage.setItem(
            LOCAL_STORAGE.EXTERNAL_LOGIN_LINK,
            result.detail.message != "Config not Found" ? result.detail.data : result.detail.message
          );

        setupInterceptor(store, relogin, errRedirect);
      } catch (error) {
        console.error("Error fetching external login link:", error);
      } finally {
        setMounted(true);
      }
    };

    initialize();
  }, []);

  return mounted ? <MainRoutes /> : null;
}

export default App;
